################################################################################
#
# ivi-homescreen
#
################################################################################

IVI_HOMESCREEN_VERSION = a038ce00031ed5a9a89b4d8dd7dbde5e3d7ade6e
IVI_HOMESCREEN_SITE = https://github.com/toyota-connected/ivi-homescreen.git
IVI_HOMESCREEN_SITE_METHOD = git
IVI_HOMESCREEN_LICENSE = Apache-2.0, BSD-3-Clause, BSD-Style, BSL-1.0, MIT

# Keep order as listed in ivi-homescreen.hash
IVI_HOMESCREEN_LICENSE_FILES = \
	LICENSE \
	third_party/filament/libs/bluevk/include/bluevk/BlueVK.h \
	third_party/flutter/shell/platform/common/client_wrapper/core_implementations.cc \
	third_party/flutter/third_party/dart/runtime/include/dart_api.h \
	third_party/asio-1-28-1/asio/LICENSE_1_0.txt \
	third_party/flutter/third_party/rapidjson/include/rapidjson/rapidjson.h \
	third_party/sanitizers-cmake/LICENSE \
	third_party/spdlog-1.12.0/LICENSE \
	third_party/weston/protocol/ivi-application.xml

IVI_HOMESCREEN_DEPENDENCIES = \
	host-flutter-sdk-bin \
	flutter-engine \
	libxkbcommon \
	wayland \
	wayland-protocols \
	wayland-utils

IVI_HOMESCREEN_CONF_OPTS = \
	-DBUILD_CRASH_HANDLER=OFF \
	-DBUILD_PLUGIN_FILE_SELECTOR=OFF \
	-DBUILD_PLUGIN_FIREBASE_CORE=OFF \
	-DBUILD_PLUGIN_URL_LAUNCHER=OFF \
	-DBUILD_TEXTURE_NAVI_RENDER_EGL=OFF \
	-DBUILD_TEXTURE_TEST_EGL=OFF \
	-DBUILD_UNIT_TESTS=OFF \
	-DENABLE_AGL_CLIENT=OFF \
	-DENABLE_XDG_CLIENT=ON \
	-DENABLE_IVI_SHELL_CLIENT=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_IVI_SHELL_CLIENT),ON,OFF)

# Logging
IVI_HOMESCREEN_CONF_OPTS += \
	-DENABLE_DART_VM_LOGGING=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_DART_VM_LOGGING),ON,OFF) \
	-DENABLE_DLT=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_DLT_LOGGING),ON,OFF)

# EGL
IVI_HOMESCREEN_CONF_OPTS += \
	-DBUILD_EGL_TRANSPARENCY=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_EGL_TRANSPARENCY),ON,OFF) \
	-DBUILD_EGL_ENABLE_3D=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_EGL_ENABLE_3D),ON,OFF) \
	-DBUILD_EGL_ENABLE_MULTISAMPLE=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_EGL_MULTISAMPLE),ON,OFF)

# dependency-less plugins
IVI_HOMESCREEN_CONF_OPTS += \
	-DBUILD_PLUGIN_ACCESSIBILITY=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_ACCESSIBILITY_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_COMP_REGION=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_COMP_REGION_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_COMP_SURF=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_COMP_SURF_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_DESKTOP_WINDOW=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_DESKTOP_WINDOW_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_GO_ROUTER=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_GO_ROUTER_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_INTEGRATION_TEST=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_INTEGRATION_TEST_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_ISOLATE=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_ISOLATE_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_KEYBOARD_MANAGER=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_KEYBOARD_MANAGER_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_KEY_EVENT=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_KEY_EVENT_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_LAYER_PLAYGROUND=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_LAYER_PLAYGROUND_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_LOGGING=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_LOGGING_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_MOUSE_CURSOR=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_MOUSE_CURSOR_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_PACKAGE_INFO=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_PACKAGE_INFO_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_PLATFORM=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_PLATFORM_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_PLATFORM_VIEWS=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_PLATFORM_VIEWS_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_RESTORATION=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_RESTORATION_PLUGIN),ON,OFF) \
	-DBUILD_PLUGIN_TEXT_INPUT=$(if $(BR2_PACKAGE_IVI_HOMESCREEN_TEXT_INPUT_PLUGIN),ON,OFF)

# Wayland backend options
ifeq ($(BR2_PACKAGE_HAS_LIBEGL),y)
IVI_HOMESCREEN_DEPENDENCIES += libegl
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_EGL=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_EGL=OFF
endif

ifeq ($(BR2_PACKAGE_MESA3D_VULKAN_DRIVER),y)
IVI_HOMESCREEN_DEPENDENCIES += mesa3d
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_VULKAN=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_VULKAN=OFF
endif

ifeq ($(BR2_PACKAGE_LIBDRM),y)
IVI_HOMESCREEN_DEPENDENCIES += libdrm
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_DRM=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_BACKEND_WAYLAND_DRM=OFF
endif

# "plugins with external dependencies"
ifeq ($(BR2_PACKAGE_IVI_HOMESCREEN_AUDIO_PLAYERS),y)
IVI_HOMESCREEN_DEPENDENCIES += gstreamer1 gst1-plugins-base
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_AUDIO_PLAYERS=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_AUDIO_PLAYERS=OFF
endif

ifeq ($(BR2_PACKAGE_IVI_HOMESCREEN_FLUTTER_SECURE_STORAGE_PLUGIN),y)
IVI_HOMESCREEN_DEPENDENCIES += libsecret
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_SECURE_STORAGE=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_SECURE_STORAGE=OFF
endif

ifeq ($(BR2_PACKAGE_IVI_HOMESCREEN_GOOGLE_SIGN_IN_PLUGIN),y)
IVI_HOMESCREEN_DEPENDENCIES += libcurl
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_GOOGLE_SIGN_IN=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_GOOGLE_SIGN_IN=OFF
endif

ifeq ($(BR2_PACKAGE_IVI_HOMESCREEN_GSTREAMER_EGL_PLUGIN),y)
IVI_HOMESCREEN_DEPENDENCIES += ffmpeg gstreamer1 gst1-plugins-base
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_GSTREAMER_EGL=ON
else
IVI_HOMESCREEN_CONF_OPTS += -DBUILD_PLUGIN_GSTREAMER_EGL=OFF
endif

ifeq ($(BR2_PACKAGE_IVI_HOMESCREEN_OPENGL_TEXTURE_PLUGIN),y)
IVI_HOMESCREEN_CONF_OPTS += \
	-DBUILD_PLUGIN_OPENGL_TEXTURE=ON \
	-DBUILD_TEXTURE_EGL=ON
else
IVI_HOMESCREEN_CONF_OPTS += \
	-DBUILD_PLUGIN_OPENGL_TEXTURE=OFF \
	-DBUILD_TEXTURE_EGL=OFF
endif

$(eval $(cmake-package))
