################################################################################
#
# dillo
#
################################################################################

DILLO_VERSION = 3.2.0
DILLO_SOURCE = dillo-$(DILLO_VERSION).tar.bz2
DILLO_SITE = https://github.com/dillo-browser/dillo/releases/download/v$(DILLO_VERSION)
DILLO_LICENSE = GPL-3.0+
DILLO_LICENSE_FILES = COPYING
DILLO_DEPENDENCIES = fltk zlib \
	$(if $(BR2_PACKAGE_LIBICONV),libiconv)
DILLO_CONF_ENV = ac_cv_path_FLTK_CONFIG=$(STAGING_DIR)/usr/bin/fltk-config

ifeq ($(BR2_PACKAGE_OPENSSL),y)
DILLO_CONF_OPTS += --enable-tls
DILLO_DEPENDENCIES += openssl
else
DILLO_CONF_OPTS += --disable-tls
endif

ifeq ($(BR2_PACKAGE_LIBPNG),y)
DILLO_CONF_OPTS += --enable-png
DILLO_DEPENDENCIES += libpng
DILLO_CONF_ENV += PNG_CONFIG=$(STAGING_DIR)/usr/bin/libpng-config
else
DILLO_CONF_OPTS += --disable-png
endif

ifeq ($(BR2_PACKAGE_JPEG),y)
DILLO_CONF_OPTS += --enable-jpeg
DILLO_DEPENDENCIES += jpeg
else
DILLO_CONF_OPTS += --disable-jpeg
endif

ifeq ($(BR2_TOOLCHAIN_HAS_THREADS),y)
DILLO_CONF_OPTS += --enable-threaded-dns
else
DILLO_CONF_OPTS += --disable-threaded-dns
endif

$(eval $(autotools-package))
