################################################################################
#
# wilc-driver
#
################################################################################

WILC_DRIVER_VERSION = 2fe5db970acc0c0df1cfd6a49087ee87dfdd01f8
WILC_DRIVER_SITE = $(call github,benetti-engineering,wilc3000-external-module,$(WILC_DRIVER_VERSION))

WILC_DRIVER_LICENSE = GPL-2.0
WILC_DRIVER_LICENSE_FILES = LICENSE

ifeq ($(BR2_PACKAGE_WILC_DRIVER_SPI),y)
WILC_DRIVER_MODULE_MAKE_OPTS += \
	CONFIG_WILC_SPI=m
define WILC_DRIVER_SPI_LINUX_CONFIG_FIXUPS
	$(call KCONFIG_ENABLE_OPT,CONFIG_SPI)
endef
endif

ifeq ($(BR2_PACKAGE_WILC_DRIVER_SDIO),y)
WILC_DRIVER_MODULE_MAKE_OPTS += \
	CONFIG_WILC_SDIO=m
define WILC_DRIVER_SDIO_LINUX_CONFIG_FIXUPS
	$(call KCONFIG_ENABLE_OPT,CONFIG_MMC)
endef
endif

ifeq ($(BR2_PACKAGE_WILC_DRIVER_SDIO_OOB),y)
WILC_DRIVER_MODULE_MAKE_OPTS += \
	CONFIG_WILC_HW_OOB_INTR=y
endif

define WILC_DRIVER_LINUX_CONFIG_FIXUPS
	$(call KCONFIG_ENABLE_OPT,CONFIG_NET)
	$(call KCONFIG_ENABLE_OPT,CONFIG_WIRELESS)
	$(call KCONFIG_ENABLE_OPT,CONFIG_CFG80211)
	$(call KCONFIG_ENABLE_OPT,CONFIG_CRC_ITU_T)
	$(call KCONFIG_ENABLE_OPT,CONFIG_CRC7)
	$(WILC_DRIVER_SPI_LINUX_CONFIG_FIXUPS)
	$(WILC_DRIVER_SDIO_LINUX_CONFIG_FIXUPS)
endef

$(eval $(kernel-module))
$(eval $(generic-package))
