################################################################################
#
# libvncserver
#
################################################################################

LIBVNCSERVER_VERSION = 0.9.15
LIBVNCSERVER_SITE = $(call github,LibVNC,libvncserver,LibVNCServer-$(LIBVNCSERVER_VERSION))
LIBVNCSERVER_LICENSE = GPL-2.0+
LIBVNCSERVER_LICENSE_FILES = COPYING
LIBVNCSERVER_CPE_ID_VALID = YES
LIBVNCSERVER_INSTALL_STAGING = YES
LIBVNCSERVER_DEPENDENCIES = host-pkgconf lzo
LIBVNCSERVER_CONF_OPTS = -DWITH_LZO=ON

# only used for examples
LIBVNCSERVER_CONF_OPTS += \
	-DWITH_FFMPEG=OFF \
	-DWITH_GTK=OFF \
	-DWITH_SDL=OFF \
	-DWITH_TESTS=OFF

ifeq ($(BR2_TOOLCHAIN_HAS_THREADS),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_THREADS=ON
else
LIBVNCSERVER_CONF_OPTS += -DWITH_THREADS=OFF
endif

# openssl supports needs NPTL thread support
ifeq ($(BR2_PACKAGE_OPENSSL)$(BR2_TOOLCHAIN_HAS_THREADS_NPTL),yy)
LIBVNCSERVER_CONF_OPTS += -DWITH_OPENSSL=ON
LIBVNCSERVER_DEPENDENCIES += openssl
else
LIBVNCSERVER_CONF_OPTS += -DWITH_OPENSSL=OFF
endif

ifeq ($(BR2_PACKAGE_LIBGCRYPT),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_GCRYPT=ON
LIBVNCSERVER_DEPENDENCIES += libgcrypt
else
LIBVNCSERVER_CONF_OPTS += -DWITH_GCRYPT=OFF
endif

ifeq ($(BR2_PACKAGE_GNUTLS)$(BR2_PACKAGE_LIBGCRYPT),yy)
LIBVNCSERVER_CONF_OPTS += -DWITH_GNUTLS=ON
LIBVNCSERVER_DEPENDENCIES += gnutls
else
LIBVNCSERVER_CONF_OPTS += -DWITH_GNUTLS=OFF
endif

ifeq ($(BR2_PACKAGE_JPEG),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_JPEG=ON
LIBVNCSERVER_DEPENDENCIES += jpeg
else
LIBVNCSERVER_CONF_OPTS += -DWITH_JPEG=OFF
endif

ifeq ($(BR2_PACKAGE_LIBPNG),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_PNG=ON
LIBVNCSERVER_DEPENDENCIES += libpng
else
LIBVNCSERVER_CONF_OPTS += -DWITH_PNG=OFF
endif

ifeq ($(BR2_PACKAGE_SYSTEMD),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_SYSTEMD=ON
LIBVNCSERVER_DEPENDENCIES += systemd
else
LIBVNCSERVER_CONF_OPTS += -DWITH_SYSTEMD=OFF
endif

ifeq ($(BR2_PACKAGE_ZLIB),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_ZLIB=ON
LIBVNCSERVER_DEPENDENCIES += zlib
else
LIBVNCSERVER_CONF_OPTS += -DWITH_ZLIB=OFF
endif

ifeq ($(BR2_PACKAGE_LIBVNCSERVER_WEBSOCKETS),y)
HBT_LIBVNCSERVER_CONF_OPTS += -DWITH_WEBSOCKETS=ON

define LIBVNCSERVER_INSTALL_VNC
	$(INSTALL) -D -m 644 $(@D)/webclients/index.vnc \
		$(TARGET_DIR)/usr/share/vnc/index.vnc
endef

LIBVNCSERVER_POST_INSTALL_TARGET_HOOKS += LIBVNCSERVER_INSTALL_VNC
else
LIBVNCSERVER_CONF_OPTS += -DWITH_WEBSOCKETS=OFF
endif

ifeq ($(BR2_PACKAGE_LIBVNCSERVER_INSTALL_STOREPASSSWD),y)
LIBVNCSERVER_CONF_OPTS += -DWITH_EXAMPLES=ON
define LIBVNCSERVER_INSTALL_STOREPASSWD
	$(INSTALL) -D -m 0755 $(@D)/examples/server/storepasswd \
		$(TARGET_DIR)/usr/bin/storepasswd
endef

LIBVNCSERVER_POST_INSTALL_TARGET_HOOKS += LIBVNCSERVER_INSTALL_STOREPASSWD
else
LIBVNCSERVER_CONF_OPTS += -DWITH_EXAMPLES=OFF
endif

$(eval $(cmake-package))
